<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=yes">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Earning Source Lab - Login</title> 
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <style>
        /* --- Color Palette (Deep Blue & White - Replaced Pink) --- */
        :root {
            --primary-blue: #214ebe; /* Deep Blue */
            --primary-light: #52a3ff; /* Lighter Blue for highlights/hover */
            --white-bg: #f0f2f5; 
            --card-color: #ffffff;
            --text-color: #333;
            /* Shadows remain Neumorphic/Soft UI style */
            --soft-shadow: 15px 15px 30px rgba(0, 0, 0, 0.1), -15px -15px 30px rgba(255, 255, 255, 0.7);
            /* Blue shadow for the button */
            --button-shadow: 6px 6px 15px rgba(33, 78, 190, 0.4);
            
            /* Success color for popup */
            --success-color: #4caf50;
        }

        /* 1. Body/Background (Refresh Enabled) */
        * { margin: 0; padding: 0; box-sizing: border-box; }
        html, body {
            width: 100%; height: 100%; 
            font-family: 'Poppins', sans-serif;
            background: var(--white-bg); 
            color: var(--text-color);
            display: flex; align-items: center; justify-content: center; min-height: 100vh;
            overflow: auto; 
        }
        
        /* 2. Login Box Design: Compact Floating Card */
        .login-box {
            width: 90%; 
            max-width: 350px; 
            background: var(--card-color);
            border-radius: 20px; 
            padding: 30px; 
            box-shadow: var(--soft-shadow); 
            transition: all 0.5s cubic-bezier(0.19, 1, 0.22, 1);
            border: 1px solid rgba(255, 255, 255, 0.8);
            margin: 20px 0; 
        }
        .login-box:hover {
            transform: scale(1.02); 
            box-shadow: 20px 20px 40px rgba(0, 0, 0, 0.15), -10px -10px 20px rgba(255, 255, 255, 0.5);
        }

        /* 3. Header Design (Blue Accent) */
        .brand-header { 
            text-align: center; 
            margin-bottom: 25px; 
            position: relative;
        }
        .brand-header h1 {
            font-size: 36px; 
            font-weight: 800;
            color: var(--primary-blue); /* Changed from Pink */
            letter-spacing: 2px;
            text-shadow: 2px 2px 5px rgba(33, 78, 190, 0.2); /* Changed from Pink */
            position: relative;
            z-index: 2;
        }
        .brand-header h1::after {
            content: "";
            position: absolute;
            bottom: -10px;
            left: 50%;
            transform: translateX(-50%);
            width: 40px; 
            height: 3px; 
            background: var(--primary-light); /* Changed from Pink */
            border-radius: 2px;
        }
        .brand-header p {
            color: var(--text-color); font-weight: 500; font-size: 13px; margin-top: 10px;
        }

        /* 4. Input Field Design: Inset (Blue Accent) */
        .form-group { margin-bottom: 20px; }
        label {
            display: block; margin-bottom: 8px; font-weight: 600; font-size: 13px; 
            color: var(--text-color);
        }
        label span { color: var(--primary-blue); } /* Changed from Pink */

        .input-box {
            display: flex; align-items: center;
            background: var(--white-bg); 
            border-radius: 10px; 
            padding: 10px 15px; 
            box-shadow: inset 4px 4px 8px rgba(0, 0, 0, 0.08), inset -4px -4px 8px rgba(255, 255, 255, 0.9);
            border: 1px solid rgba(255, 255, 255, 0.5);
            transition: all 0.3s;
        }
        .input-box:focus-within {
            box-shadow: inset 2px 2px 5px rgba(0, 0, 0, 0.05), inset -2px -2px 5px rgba(255, 255, 255, 0.8);
            border: 1px solid var(--primary-light); /* Changed from Pink */
        }

        .input-icon {
            color: var(--primary-blue); /* Changed from Pink */
            font-size: 16px; 
            margin-right: 10px; 
        }
        
        .phone-prefix {
            font-weight: 600;
            margin-right: 8px;
            padding-right: 8px;
            color: var(--primary-blue); /* Changed from Pink */
            border-right: 1px solid rgba(33, 78, 190, 0.3); /* Changed from Pink */
            font-size: 14px;
        }
        .input-field {
            border: none; outline: none; background: transparent;
            flex-grow: 1; font-size: 15px; color: var(--text-color);
            padding: 0;
        }
        .password-toggle { 
            color: var(--primary-blue); /* Changed from Pink */
            cursor: pointer; padding: 0 5px; opacity: 0.7; transition: opacity 0.2s; 
        }

        /* 5. Checkbox/Remember Me (Blue Accent) */
        .remember-me { font-size: 13px; margin-top: 10px; display: flex; align-items: center;}
        .remember-me label { margin-bottom: 0; }
        .remember-me input { 
            width: 14px; height: 14px; margin-right: 5px; 
            accent-color: var(--primary-blue); /* Changed from Pink */
        }

        /* 6. Button Design: Soft/Raised Effect (Blue) */
        .login-btn {
            width: 100%; border: none; margin-top: 25px; 
            padding: 14px; 
            background: var(--primary-blue); /* Changed from Pink */
            color: var(--card-color);
            font-weight: 700; font-size: 16px; 
            border-radius: 10px; 
            cursor: pointer;
            box-shadow: var(--button-shadow); /* Changed from Pink shadow */
            transition: all 0.3s ease-out;
            text-transform: uppercase;
        }
        .login-btn:hover {
            background: var(--primary-light); /* Changed from Pink */
            box-shadow: 8px 8px 20px rgba(33, 78, 190, 0.6); /* Changed from Pink shadow */
            transform: translateY(-2px);
        }
        .login-btn:active {
            transform: scale(0.99);
            box-shadow: inset 3px 3px 8px rgba(0, 0, 0, 0.1), inset -3px -3px 8px rgba(255, 255, 255, 0.9);
        }

        /* 7. Other Links (Blue Accent) */
        .page-links { text-align: center; margin-top: 20px; font-size: 13px; font-weight: 500; }
        .page-links a { 
            text-decoration: none; 
            color: var(--primary-blue); /* Changed from Pink */
            font-weight: 600; transition: color 0.2s; 
        }
        .page-links a:hover { color: var(--primary-light); text-decoration: underline; } /* Changed from Pink */
        .page-links .home-link { display: block; margin-top: 8px; color: #555; font-size: 12px; }

        /* 8. Popup Design (Success Green) */
        #popupOverlay { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.4); z-index: 9990; }
        #successPopup {
            display: none; position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%);
            background: var(--card-color); border-radius: 15px; padding: 30px; text-align: center;
            box-shadow: var(--soft-shadow); z-index: 9999;
        }
        #successPopup i { font-size: 45px; color: var(--success-color); margin-bottom: 15px; } /* Kept success green */

    </style>
</head>

<body>
    <div class="login-box">
        <div class="brand-header">
            <h1>Earning Source Lab</h1>
            <p>Login Your Account</p> 
        </div>

        <form id="loginForm" action="{{ route('login') }}" method="POST" novalidate>
            <div class="form-group">
                <label for="phone">Phone Number<span></span></label> 
                <div class="input-box">
                    <div class="input-icon"><i class="fas fa-mobile-alt"></i></div>
                    <div class="phone-prefix">+880</div>
                    <input type="tel" id="phone" name="phone" class="input-field" placeholder="Enter your number" required> 
                </div>
            </div>

            <div class="form-group">
                <label for="password">Password<span></span></label> 
                <div class="input-box">
                    <div class="input-icon"><i class="fas fa-lock"></i></div>
                    <input type="password" id="password" name="password" class="input-field" placeholder="Enter your password" required> 
         
            </div>

            <div class="remember-me">
                <input type="checkbox" id="remember" name="remember">
                <label for="remember">Remember Me</label> 
            </div>

            <button type="submit" class="login-btn">
                <span class="btn-text">Login</span> 
                <span class="spinner" style="display:none"><i class="fas fa-spinner fa-spin"></i></span>
            </button>

            <div class="page-links">
                Don't have an account? <a href="{{ route('register') }}">Register Now</a> 
                <a href="{{ url('/') }}" class="home-link"></a> 
            </div>
        </form>
    </div>

    <div id="popupOverlay"></div>
    <div id="successPopup">
        <i class="fas fa-check-circle"></i>
        <h4>Login Successful!</h4> 
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        function showSuccess(){
            $("#popupOverlay,#successPopup").fadeIn(200);
            setTimeout(()=>$("#popupOverlay,#successPopup").fadeOut(250),1500);
        }

        $(document).ready(function(){
            // CSRF Token Setup
            $.ajaxSetup({headers:{'X-CSRF-TOKEN':$('meta[name="csrf-token"]').attr('content')}});

            // Password Toggle Functionality
            // NOTE: The icon in HTML was initially empty. I've updated the script to handle toggling the eye/slash icons.
            $('#togglePassword').html('<i class="fas fa-eye"></i>'); 

            $('#togglePassword').on('click',function(){
                const input=$('#password');
                const type=input.attr('type')==='password'?'text':'password';
                input.attr('type',type);
                $(this).find('i').toggleClass('fa-eye fa-eye-slash');
            });

            // Login Form Submission (AJAX) - (Placeholder for actual submission logic)
            $('#loginForm').on('submit',function(e){
                e.preventDefault();
                const form=$(this);
                if(form[0].checkValidity()===false){form[0].reportValidity();return;}
                
                const btn=form.find('button');
                const text=btn.find('.btn-text');
                const sp=btn.find('.spinner');
                
                // Disable button and show spinner
                btn.prop('disabled',true);
                text.hide();
                sp.show();

                const data={};
                form.serializeArray().forEach(f=>data[f.name]=f.value);

                // Placeholder AJAX (keeping original structure)
                $.ajax({
                    url:form.attr('action'),
                    method:form.attr('method'),
                    contentType:'application/json',
                    data:JSON.stringify(data),
                    success:function(r){
                        if(r.status==='success'){
                            showSuccess();
                            setTimeout(()=>window.location.href='/dashboard',1500);
                        }
                        else {
                            alert(r.msg||'Login failed.'); 
                        }
                    },
                    error:function(xhr, status, error){
                        let errorMessage = 'Login failed. Please try again.'; 
                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            errorMessage = xhr.responseJSON.message;
                        }
                        alert(errorMessage);
                    },
                    complete:function(){
                        btn.prop('disabled',false);
                        text.show();
                        sp.hide();
                    }
                });
            });
        });
    </script>
</body>
</html>