<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
  <title>SRT LAB BD</title>

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">

  <style>
    :root {
      /* Primary Color: #214ebe (Blue-Green) */
      --primary-color: #214ebe;
      --primary-gradient: linear-gradient(135deg, #214ebe, #00c7a5);
      --background: #f0f2f5;
      --card-bg:#ffffff;
      --text-dark:#222;
      --text-muted:#777;
      --shadow: 0 8px 20px rgba(0, 0, 0, 0.08);
      --button-shadow: 0 6px 15px rgba(33, 78, 190, 0.4);
    }
    *{margin:0;padding:0;box-sizing:border-box}
    body{font-family:'Poppins',sans-serif;background:var(--background);color:var(--text-dark);padding-bottom:85px}

    /* Header (Consistent Style) */
    .header{
      background:var(--primary-color);
      color:var(--card-bg);
      padding:15px;
      text-align:center;
      font-weight:600;
      font-size:18px;
      box-shadow:0 4px 8px rgba(0,0,0,.1);
      position:sticky; top:0; z-index:100;
      border-bottom-left-radius:10px;border-bottom-right-radius:10px;
    }
    .back-btn{position:absolute;left:15px;top:15px;color:var(--card-bg);text-decoration:none;font-size:20px}

    /* Add Bank Card (Unique, Premium Look) */
    .add-bank-card{
      background:var(--card-bg);
      border-radius:18px;
      padding:40px 30px;
      text-align:center;
      margin:20px;
      border:2px solid #ddd;
      cursor:pointer;
      box-shadow:var(--shadow);
      transition:.3s;
      display:flex; flex-direction:column; align-items:center;
    }
    .add-bank-card:hover{
        border-color:var(--primary-color);
        transform:translateY(-3px);
        box-shadow:0 10px 25px rgba(33, 78, 190, 0.2);
    }
    .add-bank-card .icon{
        font-size:45px;
        background:var(--primary-gradient);
        -webkit-background-clip:text;-webkit-text-fill-color:transparent;
        margin-bottom:15px;
    }
    .add-bank-card .text{font-size:17px;font-weight:700; color:var(--primary-color);}

    /* Bank Form Container (Clean Card) */
    .bank-form-container{
      display:none;
      background:var(--card-bg);
      margin:20px;
      padding:25px;
      border-radius:18px;
      box-shadow:var(--shadow);
    }
    .form-group{margin-bottom:20px;text-align:left}
    .form-group label{font-size:13px;font-weight:600;margin-bottom:8px;display:block;color:var(--text-dark);}
    .form-control{
      width:100%;padding:12px 14px;
      border:1px solid #e0e0e0;border-radius:10px;
      font-size:15px;outline:none;
      transition:.3s;
      background:#fcfcfc;
    }
    .form-control:focus{border-color:var(--primary-color);box-shadow:0 0 0 4px rgba(33, 78, 190, 0.15)}

    .submit-btn{
      width:100%;padding:16px;
      background:var(--primary-gradient);
      border:none;border-radius:10px;
      font-size:16px;font-weight:700;
      color:var(--card-bg);cursor:pointer;
      box-shadow:var(--button-shadow);transition:.3s;
      letter-spacing:0.5px;
    }
    .submit-btn:hover{transform:translateY(-1px);box-shadow:0 8px 20px rgba(33, 78, 190, 0.6)}

    /* Bottom Menubar (Consistent Style) */
    .menubar{
      position:fixed;bottom:0;left:0;right:0;height:70px;background:var(--card-bg);
      box-shadow:0 -4px 15px rgba(0,0,0,.1);
      display:flex;justify-content:space-around;align-items:center;z-index:999;
      border-radius:16px 16px 0 0
    }
    .nav-link{display:flex;flex-direction:column;align-items:center;font-size:12px;color:#777;text-decoration:none;transition:.3s;padding:5px 0;}
    .nav-link i{font-size:20px;margin-bottom:4px}
    .nav-link.active{color:var(--primary-color);font-weight:600;}
    .zoom-btn{
      position:relative;top:-25px;width:65px;height:65px;
      background:var(--primary-gradient);border-radius:50%;
      display:flex;align-items:center;justify-content:center;
      box-shadow:var(--button-shadow);border:4px solid var(--background);
    }
    .zoom-btn i{color:var(--card-bg);font-size:24px}
  </style>
</head>
<body>

  <div class="header">

    Bank Account Info
  </div>

  <div class="add-bank-card" onclick="showBankForm()">
    <div class="icon"><i class="fas fa-university"></i></div>
    <div class="text">Add New Bank Account</div>
  </div>

  <div class="bank-form-container" id="bankForm">
    <form action="{{ route('setup.gateway.submit') }}" method="POST">
      @csrf

      <div class="form-group">
        <label>ACCOUNT HOLDER NAME</label>
        <input type="text" class="form-control" name="holdername" value="{{ auth()->user()->holder_name }}" placeholder="Enter Full Name" required>
      </div>

      <div class="form-group">
        <label>ACCOUNT NUMBER</label>
        <input type="text" class="form-control" name="gateway_number" value="{{ auth()->user()->gateway_number }}" placeholder="Enter Account Number" required>
      </div>

      <div class="form-group">
        <label>BANK / PAYMENT METHOD</label>
        <select class="form-control" name="gateway_method" required>
          <option value="">Select Bank / Method</option>
          @php
            // NOTE: The original PHP logic is retained here.
            $methods = \App\Models\PaymentMethod::select('id','name')->where('status','active')->groupBy('name')->get();
          @endphp
          @foreach($methods as $element)
            <option value="{{ $element->id }}" {{ auth()->user()->gateway_method == $element->id ? 'selected' : '' }}>
              {{ $element->name }}
            </option>
          @endforeach
        </select>
      </div>

      <button type="submit" class="submit-btn">SAVE INFORMATION</button>
    </form>
  </div>

 <!-- Bottom Navigation -->
<nav class="bottom-nav">
  <a href="/dashboard" class="nav-item" aria-label="Home">
    <svg viewBox="0 0 24 24"><path d="M3 12 L12 3 L21 12 V21 H14 V15 H10 V21 H3 Z"/></svg>
    Home
  </a>
  <a href="/my/vip" class="nav-item" aria-label="Income">
    <svg viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="10" rx="2" ry="2" /><polyline points="9 10 15 10 15 14" /></svg>
    Income
  </a>
  <a href="/my-team" class="nav-item" aria-label="Team">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M6 21v-2a4 4 0 0 1 8 0v2"/></svg>
    Team
  </a>
  <a href="/invite" class="nav-item" aria-label="Share">
    <svg viewBox="0 0 24 24"><circle cx="18" cy="5" r="3" /><circle cx="6" cy="12" r="3" /><circle cx="18" cy="19" r="3" /><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"/></svg>
    Share
  </a>
  <a href="/mine" class="nav-item active" aria-label="My Profile">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M5 21v-2a7 7 0 0 1 14 0v2"/></svg>
    My
  </a>
</nav>

<style>
/* Bottom Nav Fixed */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ddd;
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 6px 0;
  box-shadow: 0 -2px 10px rgb(0 0 0 / 10%);
  z-index: 9999; /* সব উপরে থাকবে */
}

.bottom-nav .nav-item {
  text-decoration: none;
  color: #c7b2b4;
  font-size: 12px;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 2px;
  flex: 1;
  padding: 6px 0;
  transition: 0.3s;
}

.bottom-nav .nav-item svg {
  width: 24px;
  height: 24px;
  stroke: currentColor;
  fill: none;
  stroke-width: 2;
}

.bottom-nav .nav-item.active {
  color: #214ebe;
}

.bottom-nav .nav-item:hover {
  color: #214ebe;
}
</style>

  <script>
    function showBankForm(){
      // Hide the 'Add Bank' button and show the form
      document.querySelector('.add-bank-card').style.display='none';
      document.getElementById('bankForm').style.display='block';
    }
  </script>

  @include('alert-message')

</body>
</html>