@extends('app.layout.app')
@section('app_content')
<style>
    :root{
        --primary:linear-gradient(135deg,#7b2ff7,#f107a3);
        --primary-dark:#7b2ff7;
        --bg:linear-gradient(135deg,#f9f9ff,#f4f2ff);
        --white:#fff;
        --shadow:0 8px 20px rgba(0,0,0,.08);
    }
    body{background:var(--bg)!important;}

    .menu{
        margin:15px auto 20px;
        background:#fff;
        border-radius:12px;
        box-shadow:var(--shadow);
        overflow:hidden;
    }
    .menu ul{display:flex;list-style:none;padding:0;margin:0}
    .menu ul li{flex:1;text-align:center}
    .menu ul li a{
        display:block;padding:12px;font-weight:700;
        color:#555;text-decoration:none;
        transition:.3s
    }
    .menu ul li a#active{
        background:var(--primary);
        color:#fff;border-radius:12px;
        box-shadow:0 4px 12px rgba(123,47,247,.3)
    }
    .menu ul li a:hover{color:#7b2ff7}

    .all-items{margin-top:20px}
    .items{
        background:var(--white);
        border-radius:18px;
        box-shadow:var(--shadow);
        margin-bottom:22px;
        overflow:hidden;
        transition:.3s
    }
    .items:hover{transform:translateY(-5px)}
    .product-img img{width:100%;height:160px;object-fit:cover;display:block}
    .product-text{padding:15px}
    .product-text h2{
        font-size:18px;font-weight:800;margin-bottom:8px;color:#333
    }
    .product-text p{font-size:14px;color:#555;margin-bottom:6px}

    .item-rent{
        display:flex;align-items:center;justify-content:space-between;margin-top:12px
    }
    .item-rent h3{
        font-size:16px;font-weight:800;
        background:var(--primary);
        -webkit-background-clip:text;-webkit-text-fill-color:transparent;
    }
    .item-rent button{
        border:none;outline:none;
        border-radius:30px;padding:10px 20px;
        font-weight:700;font-size:14px;
        cursor:pointer;transition:.3s
    }
    .item-rent button[disabled],.item-rent button:disabled{
        background:#ccc;color:#fff;cursor:not-allowed
    }
    .item-rent button:not([disabled]){
        background:var(--primary);color:#fff;
        box-shadow:0 6px 16px rgba(123,47,247,.35)
    }
    .item-rent button:not([disabled]):hover{transform:scale(1.05)}

    /* Popup */
    .pop_purchase{
        position:fixed;top:0;left:0;width:100%;height:100%;
        background:rgba(0,0,0,.55);display:flex;
        justify-content:center;align-items:center;
        z-index:1000
    }
    .pop_container_purchase{
        background:#fff;border-radius:14px;
        padding:20px;width:85%;max-width:360px;
        text-align:center;box-shadow:var(--shadow)
    }
    .pop_container_purchase h3{
        font-size:18px;font-weight:800;margin-bottom:10px;color:#333
    }
    .pop_container_purchase p{font-size:14px;color:#555;margin-bottom:16px}
    .purchase_btns{display:flex;justify-content:space-around;align-items:center}
    .purchase_btns button{
        border:none;padding:10px 20px;border-radius:8px;
        font-weight:700;cursor:pointer
    }
    .purchase_btns button:first-child{background:#ffe6e6;color:red}
    .purchase_btns button:last-child{background:#e6ffe6;color:green}
</style>

<div class="container">
    <div class="menu">
        <ul>
            <li><a href="{{route('user.mining')}}" id="active">Less</a></li>
            <li><a href="{{route('user.mining.my')}}">Purchase</a></li>
        </ul>
    </div>

    <div class="all-items">
        @foreach(\App\Models\Package::get() as $key=>$element)
            <div class="items">
                <div class="product-img">
                    <img src="{{asset($element->photo)}}" alt="">
                </div>

                <div class="product-text">
                    <h2>{{$element->name}}</h2>
                    <p>Valid Period: {{$element->validity}} days</p>
                    <p>Settlement Currency: BDT (৳)</p>
                    <p>Daily Income: {{price($element->commission_with_avg_amount / $element->validity)}}</p>
                    <p>Total Revenue: {{price($element->commission_with_avg_amount)}}</p>

                    <div class="item-rent">
                        <h3>{{price($element->price)}}</h3>
                        @if(in_array($element->id ,my_vips()))
                            <button type="button" disabled>Current</button>
                        @else
                            <button type="button" onclick="openPopPurchase('package{{$element->id}}')">Rent</button>
                        @endif
                    </div>
                </div>
            </div>

            <div class="pop_purchase" id="package{{$element->id}}" style="display:none">
                <div class="pop_container_purchase">
                    <h3>Tips</h3>
                    <p>Are you sure you want to buy this product?</p>
                    <div class="purchase_btns">
                        <button onclick="closePopPurchase('package{{$element->id}}')">Cancel</button>
                        <button onclick="window.location.href='{{route('purchase.confirmation',$element->id)}}'">OK</button>
                    </div>
                </div>
            </div>
        @endforeach
    </div>
</div>
<div style="height:120px"></div>

<script>
    function closePopPurchase(id){
        document.getElementById(id).style.display='none';
    }
    function openPopPurchase(id){
        document.getElementById(id).style.display='flex';
    }
</script>
@endsection