<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,minimum-scale=1,minimal-ui,viewport-fit=cover">
  <title>আমার প্রোফাইল</title>

  <!-- Fonts & Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@400;600;700&display=swap" rel="stylesheet">

  <style>
    :root {
      --primary: linear-gradient(135deg,#7b2ff7,#f107a3);
      --bg: linear-gradient(135deg,#f9f9ff,#f4f2ff);
      --white:#fff;
      --dark:#333;
      --gray:#555;
      --shadow:0 6px 20px rgba(0,0,0,.08);
    }
    *{margin:0;padding:0;box-sizing:border-box}
    body{font-family:'Hind Siliguri',sans-serif;background:var(--bg);padding-bottom:90px;color:var(--dark)}

    /* Balance Card */
    .balance-card{
      background:var(--primary);
      border-radius:18px;
      padding:20px;
      margin:20px 15px;
      color:#fff;
      box-shadow:var(--shadow);
      text-align:center;
    }
    .balance-label{font-size:15px;opacity:.9;margin-bottom:8px}
    .balance-amount{font-size:28px;font-weight:800;letter-spacing:1px}
    .balance-detail{margin-top:8px;font-size:13px;opacity:.85}

    /* Options Grid */
    .options-grid{
      display:grid;
      grid-template-columns:repeat(4,1fr);
      gap:18px 12px;
      margin:25px 15px;
    }
    .option-btn{
      background:var(--white);
      border-radius:14px;
      padding:14px 8px;
      text-align:center;
      text-decoration:none;
      color:var(--dark);
      font-size:13px;
      font-weight:600;
      box-shadow:var(--shadow);
      transition:.3s;
      display:flex;flex-direction:column;align-items:center;justify-content:center;
    }
    .option-btn:hover{transform:translateY(-4px);box-shadow:0 6px 20px rgba(123,47,247,.3)}
    .option-icon{
      width:42px;height:42px;border-radius:12px;
      background:var(--primary);
      display:flex;align-items:center;justify-content:center;
      margin-bottom:6px;
    }
    .option-icon i{color:#fff;font-size:18px}

    /* Navbar */
    .menubar{position:fixed;bottom:0;left:0;right:0;height:70px;background:#fff;
      box-shadow:0 -6px 18px rgba(0,0,0,.08);display:flex;justify-content:space-around;align-items:center;z-index:999;border-radius:16px 16px 0 0}
    .nav-link{display:flex;flex-direction:column;align-items:center;font-size:13px;text-decoration:none;color:#777;font-weight:600}
    .nav-link i{font-size:22px;margin-bottom:4px}
    .nav-link.active{color:#7b2ff7}
  </style>
</head>
<body>

  <!-- Balance Section -->
  <div class="balance-card">
    <div class="balance-label">একাউন্ট ব্যালেন্স</div>
    <div class="balance-amount">৳{{ number_format(auth()->user()->balance, 2) }}</div>
    <div class="balance-detail">আইডি: {{ auth()->user()->id }}</div>
  </div>

  <!-- Options -->
  <div class="options-grid">
    <a href="/user/recharge" class="option-btn"><div class="option-icon"><i class="fa-solid fa-sack-dollar"></i></div><span>রিচার্জ</span></a>
    <a href="/withdraw" class="option-btn"><div class="option-icon"><i class="fa-solid fa-arrow-right-arrow-left"></i></div><span>প্রত্যাহার</span></a>
    <a href="/invite" class="option-btn"><div class="option-icon"><i class="fa-solid fa-user-plus"></i></div><span>আমন্ত্রণ</span></a>
    <a href="/history" class="option-btn"><div class="option-icon"><i class="fa-solid fa-file-invoice"></i></div><span>লেনদেন</span></a>
    <a href="/faq" class="option-btn"><div class="option-icon"><i class="fa-solid fa-circle-question"></i></div><span>প্রশ্নোত্তর</span></a>
    <a href="/my-team" class="option-btn"><div class="option-icon"><i class="fa-solid fa-people-group"></i></div><span>দল</span></a>
    <a href="/deposit/record" class="option-btn"><div class="option-icon"><i class="fa-solid fa-wallet"></i></div><span>ডিপোজিট</span></a>
    <a href="/my/vip" class="option-btn"><div class="option-icon"><i class="fa-solid fa-chart-line"></i></div><span>বিনিয়োগ</span></a>
  </div>

  <!-- Navbar -->
  <div class="menubar">
    <a href="/" class="nav-link"><i class="fa-solid fa-house"></i><span>হোম</span></a>
    <a href="/invite" class="nav-link"><i class="fa-solid fa-user-group"></i><span>আমন্ত্রণ</span></a>
    <a href="/mine" class="nav-link active"><i class="fa-solid fa-user"></i><span>আমার</span></a>
  </div>
</body>
</html>