<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
  <title>SRT LAB BD</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">

  <style>
    :root {
      --primary-color: #214ebe;
      --primary-gradient: linear-gradient(135deg, #214ebe, #00c7a5);
      --background: #f0f2f5;
      --card-bg:#ffffff;
      --text-dark:#222;
      --text-muted:#777;
      --shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
      --button-shadow: 0 8px 20px rgba(33, 78, 190, 0.5);
      --danger-color: #e53935;
    }
    *{margin:0;padding:0;box-sizing:border-box}
    html, body{height:100%;}
    body{
        font-family:'Poppins',sans-serif;
        background:var(--background);
        color:var(--text-dark);
        overflow-x:hidden;
        display:flex;
        flex-direction:column;
        padding-top: 55px;  /* header height */
        padding-bottom: 85px; /* menubar height */
    }

    /* Header */
    .header{
      background:var(--primary-color);
      color:var(--card-bg);
      padding:15px;text-align:center;
      font-weight:600;font-size:18px;
      box-shadow:0 4px 8px rgba(0,0,0,.15);
      position:fixed;
      top:0; left:0; right:0;
      z-index:1000;
    }
    .back-btn{position:absolute;left:15px;top:15px;color:var(--card-bg);text-decoration:none;font-size:20px}

    /* Scrollable content wrapper */
    .content-inner{
        padding:15px;
        flex:1 1 auto;
        overflow-y:auto;
    }

    /* Account Status Card */
    .account-status-card{
        background:var(--card-bg);
        border-radius:12px;
        padding:15px;
        margin-bottom:15px;
        box-shadow:var(--shadow);
        border-left:5px solid var(--primary-color);
        cursor:pointer;
        transition:.3s;
    }
    .account-status-card:hover{background:#f8faff; box-shadow:0 8px 20px rgba(33, 78, 190, 0.1);}
    .account-status-card .label{font-size:11px; font-weight:500; color:var(--text-muted); margin-bottom:3px;}
    .account-status-card .details{display:flex; justify-content:space-between; align-items:center;}
    .account-status-card .name{font-size:15px; font-weight:600; color:var(--text-dark);}
    .account-status-card .name.unlinked{color:var(--danger-color);}

    /* Main Withdraw Card */
    .main-withdraw-card{
      background:var(--card-bg);
      border-radius:12px;
      box-shadow:var(--shadow);
      margin-bottom:15px;
      padding:20px;
    }
    .balance-header{
        display:flex; justify-content:space-between; align-items:center;
        padding-bottom:15px; 
        margin-bottom:15px;
        border-bottom:1px solid #eee;
    }
    .balance-header .label{font-size:13px; font-weight:500; color:var(--text-muted);}
    .balance-header .amount{font-size:24px; font-weight:800; color:var(--primary-color);}

    .input-section .label{
        font-size:14px; font-weight:600; color:var(--text-dark); margin-bottom:10px;
    }
    .input-wrapper{
      display:flex;align-items:baseline;
      border:1px solid #ddd;
      border-radius:8px;
      padding:8px 12px;
      transition: all 0.2s;
    }
    .input-wrapper:focus-within {
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(33, 78, 190, 0.1);
    }
    .input-wrapper span{font-size:20px;font-weight:700;color:var(--text-dark);margin-right:8px;}
    .withdraw-input{
      flex-grow:1;border:none;
      font-size:22px;
      font-weight:700;color:var(--text-dark);
      padding:0;
      background:transparent;
    }
    .withdraw-input:focus{outline:none;}

    /* Fee Details */
    .fee-details .fee-row{display:flex;justify-content:space-between;font-size:14px;margin-bottom:8px; padding:3px 0;}
    .fee-details .fee-row .label{color:var(--text-muted); font-weight:500;}
    .fee-details .fee-row .value{font-weight:600;}
    .fee-details .fee-row.total{border-top:1px solid #eee; margin-top:10px; padding-top:12px;}
    .fee-details .fee-row.total .value{color:var(--primary-color); font-size:16px; font-weight:700;}
    .fee-details .fee-row .value.fee-percent{color:var(--danger-color);}

    /* Withdrawal Notice */
    .withdrawal-notice{
        background:var(--card-bg);
        border-radius:12px;
        box-shadow:var(--shadow);
        padding:20px;
        margin-bottom:15px;
        border-left:3px solid var(--danger-color);
    }
    .withdrawal-notice h5{font-weight:700;margin-bottom:10px;color:var(--text-dark);font-size:15px;}
    .withdrawal-notice p{font-size:13px;line-height:1.6;color:var(--text-muted)}

    /* Submit Button */
    .submit-btn{
      width:100%;padding:14px;
      background:var(--primary-gradient);
      border:none;border-radius:10px;
      font-size:16px;font-weight:700;
      color:var(--card-bg);cursor:pointer;
      box-shadow:var(--button-shadow);transition:.3s;
      letter-spacing:0.5px;
      margin-top:25px;
    }
    .submit-btn:hover{transform:translateY(-1px);box-shadow:0 10px 25px rgba(33, 78, 190, 0.6)}

    /* Menubar */
    .menubar{
      position:fixed;
      bottom:0;left:0;right:0;height:70px;background:var(--card-bg);
      box-shadow:0 -4px 15px rgba(0,0,0,.1);
      display:flex;justify-content:space-around;align-items:center;z-index:999;
      border-radius:16px 16px 0 0
    }
    .nav-link{display:flex;flex-direction:column;align-items:center;font-size:12px;color:#777;text-decoration:none;padding:5px 0;}
    .nav-link i{font-size:20px;margin-bottom:4px}
    .nav-link.active{color:var(--primary-color);font-weight:600;}
    .zoom-btn{
      position:relative;top:-25px;width:65px;height:65px;
      background:var(--primary-gradient);border-radius:50%;
      display:flex;align-items:center;justify-content:center;
      box-shadow:var(--button-shadow);border:4px solid var(--background);
    }
    .zoom-btn i{color:var(--card-bg);font-size:24px}

    @media(max-width:480px){
        .balance-header .amount{font-size:20px;}
        .withdraw-input{font-size:18px;}
    }
  </style>
</head>
<body>

  <div class="header">
    <a href="javascript:history.back()" class="back-btn"><i class="fas fa-chevron-left"></i></a>
    Withdraw Funds
  </div>

  <div class="content-inner">
    <form action="{{route('user.withdraw-confirm-submit')}}" method="POST">
      @csrf

      <div class="account-status-card" onclick="window.location.href='/add/card'">
        <div class="label">WITHDRAWAL ACCOUNT</div>
        <div class="details">
          <div class="info">
             @if(auth()->user()->holder_name)
              <i class="fas fa-university" style="margin-right: 8px; font-size: 16px; color: var(--primary-color);"></i>
              <span class="name">{{ auth()->user()->holder_name }}</span>
            @else
              <span class="name unlinked"><i class="fas fa-exclamation-triangle"></i> Account Not Linked</span>
            @endif
          </div>
        </div>
      </div>

      <div class="main-withdraw-card">
        <div class="balance-header">
            <span class="label">AVAILABLE BALANCE</span>
            <span class="amount">৳ {{ number_format(auth()->user()->balance, 2) }}</span>
        </div>

        <div class="input-section">
            <label class="label">ENTER WITHDRAWAL AMOUNT</label>
            <div class="input-wrapper">
                <span>৳</span>
                <input type="number" class="withdraw-input" name="amount" min="150" placeholder="0.00" oninput="checkAmount(this.value)" required>
            </div>
        </div>

        <div class="fee-details">
            <div class="fee-row">
                <span class="label">Minimum Withdraw:</span>
                <span class="value">৳150</span>
            </div>
            <div class="fee-row">
                <span class="label">Processing Fee:</span>
                <span class="value fee-percent">6%</span>
            </div>
            <div class="fee-row total">
                <span class="label">NET AMOUNT YOU WILL RECEIVE:</span>
                <span class="value" id="actualAmount">৳0.00</span>
            </div>
        </div>

        <button type="submit" class="submit-btn">SUBMIT WITHDRAWAL REQUEST</button>
      </div>
    </form>
  </div>

 <!-- Bottom Navigation -->
<nav class="bottom-nav">
  <a href="/dashboard" class="nav-item" aria-label="Home">
    <svg viewBox="0 0 24 24"><path d="M3 12 L12 3 L21 12 V21 H14 V15 H10 V21 H3 Z"/></svg>
    Home
  </a>
  <a href="/my/vip" class="nav-item" aria-label="Income">
    <svg viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="10" rx="2" ry="2" /><polyline points="9 10 15 10 15 14" /></svg>
    Income
  </a>
  <a href="/my-team" class="nav-item" aria-label="Team">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M6 21v-2a4 4 0 0 1 8 0v2"/></svg>
    Team
  </a>
  <a href="/invite" class="nav-item" aria-label="Share">
    <svg viewBox="0 0 24 24"><circle cx="18" cy="5" r="3" /><circle cx="6" cy="12" r="3" /><circle cx="18" cy="19" r="3" /><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"/></svg>
    Share
  </a>
  <a href="/mine" class="nav-item active" aria-label="My Profile">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M5 21v-2a7 7 0 0 1 14 0v2"/></svg>
    My
  </a>
</nav>

<style>
/* Bottom Nav Fixed */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ddd;
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 6px 0;
  box-shadow: 0 -2px 10px rgb(0 0 0 / 10%);
  z-index: 9999; /* সব উপরে থাকবে */
}

.bottom-nav .nav-item {
  text-decoration: none;
  color: #c7b2b4;
  font-size: 12px;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 2px;
  flex: 1;
  padding: 6px 0;
  transition: 0.3s;
}

.bottom-nav .nav-item svg {
  width: 24px;
  height: 24px;
  stroke: currentColor;
  fill: none;
  stroke-width: 2;
}

.bottom-nav .nav-item.active {
  color: #214ebe;
}

.bottom-nav .nav-item:hover {
  color: #214ebe;
}
</style>

  @include('alert-message')

  <script>
    function checkAmount(amount){
      const feeRate = 0.06;
      let actualAmount = 0;
      let inputAmount = parseFloat(amount);
      if (!isNaN(inputAmount) && inputAmount >= 150){
        let feeAmount = inputAmount * feeRate;
        actualAmount = inputAmount - feeAmount;
      }
      document.getElementById('actualAmount').innerText = '৳' + actualAmount.toFixed(2);
    }

    document.addEventListener('DOMContentLoaded', () => {
        const inputField = document.querySelector('.withdraw-input');
        if (inputField.value) {
            checkAmount(inputField.value);
        }
    });
  </script>

</body>
</html>
