<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,minimum-scale=1,viewport-fit=cover">
  <title>রেকর্ডসমূহ</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root{
      --primary-gradient: linear-gradient(135deg,#ff4da6,#ffd700);
      --background: linear-gradient(135deg,#f9f9ff,#f4f2ff);
      --card-bg:#fff;
      --text-dark:#333;
      --shadow:0 6px 18px rgba(255,77,166,.25),0 0 15px #ffd700;
    }
    *{margin:0;padding:0;box-sizing:border-box}
    body{font-family:'Noto Sans Bengali',sans-serif;background:var(--background);color:var(--text-dark);padding-bottom:80px}

    /* Header */
    .header{
      background:var(--primary-gradient);
      color:#fff;text-align:center;
      padding:16px;
      border-bottom-left-radius:16px;border-bottom-right-radius:16px;
      box-shadow:var(--shadow);
    }
    .header h2{margin:0;font-size:20px;font-weight:800}

    /* Tabs */
    .tabs{
      display:flex;gap:8px;
      background:#eee;border-radius:12px;
      padding:6px;margin:16px;
      box-shadow:inset 0 1px 3px rgba(0,0,0,.05)
    }
    .tab{
      flex:1;text-align:center;
      padding:10px 8px;border-radius:10px;
      cursor:pointer;font-weight:700;
      font-size:14px;color:#555;transition:.25s
    }
    .tab.active{
      background:var(--primary-gradient);color:#fff;
      box-shadow:var(--shadow)
    }
    .tab-content{display:none}
    .tab-content.active{display:block}

    /* Card */
    .card{
      background:var(--card-bg);border-radius:14px;
      box-shadow:var(--shadow);
      padding:14px;margin:12px 16px
    }
    .muted{color:#666;font-size:13px}

    table{width:100%;border-collapse:collapse;margin-top:8px}
    th,td{padding:10px 8px;border-bottom:1px solid #f1f1f1;text-align:left;font-size:14px}
    th{font-weight:700}
    .badge{
      display:inline-block;padding:4px 10px;border-radius:999px;font-size:12px;font-weight:700;color:#fff;
      background:var(--primary-gradient);box-shadow:var(--shadow)
    }

    /* Bottom Navbar */
    .menubar{
      position:fixed;bottom:0;left:0;right:0;height:70px;background:#fff;
      box-shadow:0 -4px 15px rgba(0,0,0,.1);
      display:flex;justify-content:space-around;align-items:center;z-index:999;
      border-radius:16px 16px 0 0
    }
    .nav-link{display:flex;flex-direction:column;align-items:center;font-size:12px;color:#777;text-decoration:none;transition:.3s}
    .nav-link i{font-size:20px;margin-bottom:4px}
    .nav-link.active{color:#ff4da6;font-weight:600;text-shadow:0 0 10px #ffd700}
    .zoom-btn{
      position:relative;top:-28px;width:75px;height:75px;
      background:var(--primary-gradient);border-radius:50%;
      display:flex;align-items:center;justify-content:center;
      box-shadow:var(--shadow);border:4px solid #fff
    }
    .zoom-btn i{color:#fff;font-size:26px}
  </style>
</head>
<body>

  <!-- Header -->
  <div class="header"><h2>📜 রেকর্ডসমূহ</h2></div>

  <!-- Tabs -->
  <div class="tabs">
    <div class="tab active" data-tab="commission">দৈনিক কমিশন</div>
    <div class="tab" data-tab="deposit">ডিপোজিট</div>
    <div class="tab" data-tab="withdraw">উত্তোলন</div>
  </div>

  <!-- Commission -->
  <div id="commission" class="tab-content active">
    <div class="card">
      <table>
        <thead><tr><th>তারিখ</th><th>প্যাকেজ</th><th>পরিমাণ</th><th>স্ট্যাটাস</th></tr></thead>
        <tbody>
          @php
            $commissions = \App\Models\UserLedger::where('user_id',auth()->id())
              ->where('reason','LIKE','daily_claim%')
              ->latest()->get();
          @endphp
          @forelse($commissions as $c)
            <tr>
              <td>{{ $c->created_at->format('Y-m-d H:i') }}</td>
              <td>{{ str_replace('daily_claim_','',$c->reason) }}</td>
              <td>৳ {{ number_format($c->amount,2) }}</td>
              <td><span class="badge">Success</span></td>
            </tr>
          @empty
            <tr><td colspan="4">কোনো কমিশন রেকর্ড নেই</td></tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>

  <!-- Deposit -->
  <div id="deposit" class="tab-content">
    <div class="card">
      <table>
        <thead><tr><th>তারিখ</th><th>মাধ্যম</th><th>পরিমাণ</th><th>স্ট্যাটাস</th></tr></thead>
        <tbody>
          @php
            $deposits = \App\Models\Deposit::where('user_id',auth()->id())->latest()->get();
          @endphp
          @forelse($deposits as $d)
            <tr>
              <td>{{ $d->created_at->format('Y-m-d H:i') }}</td>
              <td>{{ $d->method ?? '-' }}</td>
              <td>৳ {{ number_format($d->amount,2) }}</td>
              <td><span class="badge">{{ ucfirst($d->status) }}</span></td>
            </tr>
          @empty
            <tr><td colspan="4">কোনো ডিপোজিট রেকর্ড নেই</td></tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>

  <!-- Withdraw -->
  <div id="withdraw" class="tab-content">
    <div class="card">
      <table>
        <thead><tr><th>তারিখ</th><th>অ্যাকাউন্ট</th><th>পরিমাণ</th><th>স্ট্যাটাস</th></tr></thead>
        <tbody>
          @php
            $withdraws = \App\Models\Withdrawal::where('user_id',auth()->id())->latest()->get();
          @endphp
          @forelse($withdraws as $w)
            <tr>
              <td>{{ $w->created_at->format('Y-m-d H:i') }}</td>
              <td>{{ $w->account ?? '-' }}</td>
              <td>৳ {{ number_format($w->amount,2) }}</td>
              <td><span class="badge">{{ ucfirst($w->status) }}</span></td>
            </tr>
          @empty
            <tr><td colspan="4">কোনো উত্তোলন রেকর্ড নেই</td></tr>
          @endforelse
        </tbody>
      </table>
    </div>
  </div>

  <!-- Bottom Navbar -->
  <div class="menubar">
    <a href="/" class="nav-link active"><i class="fa-solid fa-house"></i><span>হোম</span></a>
    <a href="/my/vip" class="zoom-btn"><i class="fa-solid fa-fingerprint"></i></a>
    <a href="/mine" class="nav-link"><i class="fa-solid fa-user"></i><span>প্রোফাইল</span></a>
  </div>

  <script>
    // Tab switcher
    document.querySelectorAll('.tab').forEach(t=>{
      t.addEventListener('click',function(){
        document.querySelectorAll('.tab').forEach(x=>x.classList.remove('active'));
        document.querySelectorAll('.tab-content').forEach(c=>c.classList.remove('active'));
        this.classList.add('active');
        document.getElementById(this.dataset.tab).classList.add('active');
      });
    });
  </script>
</body>
</html>