<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
    <title>SRT LOAB BD</title>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+Bengali:wght@400;500;600;700&family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">

    <style>
        /* NEW Color Palette (Indigo Blue: #214ebe) */
        :root {
            --primary-color: #214ebe; /* New primary color: #214ebe */
            --light-bg-blue: #e6f0ff; /* Light blue for stat boxes */
            --primary-gradient: linear-gradient(135deg, var(--primary-color), #3a59d0); /* Gradient using new color */
            --background: #f8f9fa; 
            --card-bg: #fff;
            --text-dark: #212529; 
            /* Shadow using the new primary color */
            --shadow: 0 4px 15px rgba(33, 78, 190, 0.2), 0 0 8px rgba(33, 78, 190, 0.1);
        }
        *{margin:0;padding:0;box-sizing:border-box}
        body{font-family:'Poppins', 'Noto Sans Bengali', sans-serif;background:var(--background);color:var(--text-dark);padding-bottom:85px}

        /* Header */
        .header{
            background:var(--primary-color); /* Applied #214ebe */
            padding:15px;text-align:center;color:#fff;
            font-weight:700;font-size:18px;
            box-shadow:0 3px 10px rgba(33, 78, 190, 0.4); /* Shadow with new color */
         
            position:sticky; 
            top:0;
            z-index: 1000;
        }
        .back-btn{position:absolute;left:15px;top:15px;color:#fff;text-decoration:none;font-size:20px}

        .container{padding:15px}

        /* Report Section */
        .report-section{
            background:var(--card-bg);
            border-radius:12px;
            box-shadow:0 3px 10px rgba(0,0,0,0.1);
            border: 1px solid #e9ecef;
            padding:20px;
            padding-top: 50px; 
            margin-bottom:25px;
            position:relative;
            overflow: hidden;
        }
        .report-section .level-badge{
            background:var(--primary-color); /* Applied #214ebe */
            color:#fff;font-weight:700;
            padding:8px 20px;
            border-radius:0 0 10px 10px;
            position:absolute;top:0;left:0; right:0;
            font-size:14px;
            text-align: center;
            box-shadow:0 3px 5px rgba(33, 78, 190, 0.3); /* Shadow with new color */
            text-transform: uppercase;
        }

        /* Stats Grid - 2 columns */
        .stats-grid{display:grid;grid-template-columns:1fr 1fr;gap:15px;margin-top:10px}
        .stat-box{
            border-radius:12px;
            padding:15px;
            display:flex;flex-direction: column;
            align-items: center;
            justify-content: center;
            background:var(--light-bg-blue); /* Light background for boxes */
            box-shadow:0 0 10px rgba(33, 78, 190, 0.05);
            border: 1px solid #c2d6ff;
            min-height: 100px;
        }
        .stat-box i{
            font-size:24px;
            color: var(--primary-color); /* Applied #214ebe */
            margin-bottom: 8px;
        }
        .stat-box .details{text-align: center;}
        .stat-box .details .label{font-size:13px;color:#666;margin-bottom:2px}
        .stat-box .details .value{font-size:20px;font-weight:700;color:var(--text-dark)}

        /* Floating Support */
        .support-btn{
            position:fixed;bottom:90px;right:20px;
            width:55px;height:55px;border-radius:50%;
            background:var(--primary-color); /* Applied #214ebe */
            display:flex;align-items:center;justify-content:center;
            color:#fff;font-size:22px;text-decoration:none;
            box-shadow:0 5px 15px rgba(33, 78, 190, 0.5); /* Shadow with new color */
            z-index:999;
            transition: transform 0.3s;
        }
        .support-btn:hover {transform: scale(1.05);}

        /* Bottom Menubar */
        .menubar{
            position:fixed;bottom:0;left:0;right:0;height:70px;background:#fff;
            border-radius:16px 16px 0 0;
            box-shadow:0 -4px 15px rgba(0,0,0,.1);
            display:flex;justify-content:space-around;align-items:center;
            z-index:999
        }
        .nav-link{display:flex;flex-direction:column;align-items:center;font-size:12px;color:#777;text-decoration:none; flex-basis: 25%;}
        .nav-link i{font-size:20px;margin-bottom:4px}
        .nav-link.active{color:var(--primary-color);font-weight:700;text-shadow:none} /* Applied #214ebe */
        .zoom-btn{
            position:relative;top:-20px; 
            width:60px;height:60px; 
            background:var(--primary-color); /* Applied #214ebe */
            border-radius:50%;
            display:flex;align-items:center;justify-content:center;
            box-shadow:0 5px 15px rgba(33, 78, 190, 0.5); /* Shadow with new color */
            border:4px solid #fff;
        }
        .zoom-btn i{color:#fff;font-size:24px}
    </style>
</head>
<body>

    <div class="header">
        <a href="javascript:history.back()" class="back-btn"></a>
        Team Report
    </div>

    <div class="container">
        <div class="report-section">
            <div class="level-badge">LEVEL-1</div>
            <div class="stats-grid">
                <div class="stat-box">
                    <i class="fa-solid fa-wallet"></i>
                    <div class="details">
                        <div class="label">Total Income</div>
                        <div class="value"><?php echo e($totalDeposit1 ?? 0); ?></div>
                    </div>
                </div>
                <div class="stat-box">
                    <i class="fa-solid fa-users"></i>
                    <div class="details">
                        <div class="label">Total Members</div>
                        <div class="value"><?php echo e($first_level_users->count() ?? 0); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="report-section">
            <div class="level-badge">LEVEL-2</div>
            <div class="stats-grid">
                <div class="stat-box">
                    <i class="fa-solid fa-wallet"></i>
                    <div class="details">
                        <div class="label">Total Income</div>
                        <div class="value"><?php echo e($totalDeposit2 ?? 0); ?></div>
                    </div>
                </div>
                <div class="stat-box">
                    <i class="fa-solid fa-users"></i>
                    <div class="details">
                        <div class="label">Total Members</div>
                        <div class="value"><?php echo e($second_level_users->count() ?? 0); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="report-section">
            <div class="level-badge">LEVEL-3</div>
            <div class="stats-grid">
                <div class="stat-box">
                    <i class="fa-solid fa-wallet"></i>
                    <div class="details">
                        <div class="label">Total Income</div>
                        <div class="value"><?php echo e($totalDeposit3 ?? 0); ?></div>
                    </div>
                </div>
                <div class="stat-box">
                    <i class="fa-solid fa-users"></i>
                    <div class="details">
                        <div class="label">Total Members</div>
                        <div class="value"><?php echo e($third_level_users->count() ?? 0); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

   <!-- Bottom Navigation -->
<nav class="bottom-nav">
  <a href="/dashboard" class="nav-item" aria-label="Home">
    <svg viewBox="0 0 24 24"><path d="M3 12 L12 3 L21 12 V21 H14 V15 H10 V21 H3 Z"/></svg>
    Home
  </a>
  <a href="/my/vip" class="nav-item" aria-label="Income">
    <svg viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="10" rx="2" ry="2" /><polyline points="9 10 15 10 15 14" /></svg>
    Income
  </a>
  <a href="/my-team" class="nav-item active" aria-label="Team">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M6 21v-2a4 4 0 0 1 8 0v2"/></svg>
    Team
  </a>
  <a href="/invite" class="nav-item" aria-label="Share">
    <svg viewBox="0 0 24 24"><circle cx="18" cy="5" r="3" /><circle cx="6" cy="12" r="3" /><circle cx="18" cy="19" r="3" /><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"/></svg>
    Share
  </a>
  <a href="/mine" class="nav-item" aria-label="My Profile">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M5 21v-2a7 7 0 0 1 14 0v2"/></svg>
    My
  </a>
</nav>

<style>
/* Bottom Nav Fixed */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ddd;
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 6px 0;
  box-shadow: 0 -2px 10px rgb(0 0 0 / 10%);
  z-index: 9999; /* সব উপরে থাকবে */
}

.bottom-nav .nav-item {
  text-decoration: none;
  color: #c7b2b4;
  font-size: 12px;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 2px;
  flex: 1;
  padding: 6px 0;
  transition: 0.3s;
}

.bottom-nav .nav-item svg {
  width: 24px;
  height: 24px;
  stroke: currentColor;
  fill: none;
  stroke-width: 2;
}

.bottom-nav .nav-item.active {
  color: #214ebe;
}

.bottom-nav .nav-item:hover {
  color: #214ebe;
}
</style>

</body>
</html><?php /**PATH /home/nexivo2437/public_html/resources/views/app/main/team/index.blade.php ENDPATH**/ ?>