<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,minimum-scale=1,viewport-fit=cover">
    <title>SRT LAB BD</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">

    <style>
        /* --- Root Variables and Theme Setup (Blue & White) --- */
        :root{
            --primary-color: #214ebe; /* Deep Blue */
            --primary-light: #52a3ff;
            --secondary-color: #28a745; /* Green for highlight */
            --background: #f0f4f7; /* Light gray background */
            --card-bg: #ffffff;
            --text-dark: #222;
            --text-light: #fff;
            --text-muted: #6c757d;
            --shadow-soft: 0 4px 15px rgba(0, 0, 0, 0.1);
            --shadow-strong: 0 8px 25px rgba(0, 0, 0, 0.2);
        }
        *{margin:0;padding:0;box-sizing:border-box}
        body{
            font-family:'Poppins', sans-serif;
            background:var(--background);
            color:var(--text-dark);
            padding-bottom:100px;
        }

        /* --- 1. Header (Deep Blue Background) --- */
        /* --- Header (Solid Blue, No Curve) --- */
        .header{
            background:var(--primary-color);
            padding:16px 15px;
            text-align:center;
            color:var(--card-bg);
            font-weight:700;
            font-size:18px;
            box-shadow:var(--shadow);
            position:sticky; top:0; z-index:100;
        }

        /* --- 2. Help Cards (Clean & Interactive) --- */
        .help_card_container {
            padding: 20px 15px;
        }
        .help_card{
            margin:15px 0;
            padding:20px;
            background:var(--card-bg);
            border-radius:12px;
            display:flex;
            align-items:center;
            box-shadow:var(--shadow-soft);
            text-decoration:none;
            transition:all .3s cubic-bezier(0.25, 0.46, 0.45, 0.94); /* Smooth transition */
            border-left: 5px solid transparent;
        }
        .help_card:hover{
            transform:translateY(-5px);
            border-left-color: var(--primary-color);
            box-shadow: 0 12px 25px rgba(0, 123, 255, 0.2);
        }
        
        /* Card Icon/Logo */
        .help_card .logo{
            margin-right:15px;
            width: 50px;
            height: 50px;
            min-width: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
            background: var(--primary-color);
            border-radius: 10px;
            color: var(--text-light);
            font-size: 24px;
            box-shadow: 0 4px 10px rgba(0, 123, 255, 0.3);
        }

        .help_card .title-area {
            flex-grow: 1;
        }

        .help_card .title{
            font-size:16px;
            font-weight:600;
            color:var(--text-dark);
            margin-bottom: 2px;
        }
        .help_card .describe{
            font-size:12px;
            color:var(--text-muted);
            line-height:1.4;
        }

        .help_card .arrow-icon {
            color: var(--primary-color);
            font-size: 18px;
            margin-left: 15px;
        }
        
        /* --- 3. Floating Service Button (Unique Circle) --- */
        #service{
            position:fixed;
            bottom:110px;
            right:20px;
            z-index:999;
            width: 55px;
            height: 55px;
            background: var(--secondary-color); /* Highlight color */
            border-radius:50%;
            display:flex;
            align-items:center;
            justify-content:center;
            box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7);
            animation: pulse-green 2s infinite;
            text-decoration: none;
        }
        #service i {
            color: var(--text-light);
            font-size: 26px;
        }

        @keyframes pulse-green {
            0% {box-shadow: 0 0 0 0 rgba(40, 167, 69, 0.7);}
            70% {box-shadow: 0 0 0 15px rgba(40, 167, 69, 0);}
            100% {box-shadow: 0 0 0 0 rgba(40, 167, 69, 0);}
        }

        /* --- 4. Bottom Navbar (Blue Base) --- */
        .menubar{
            position:fixed;
            bottom:0;
            left:0;
            right:0;
            height:85px;
            background:var(--card-bg);
            box-shadow:0 -5px 20px rgba(0,0,0,.15);
            display:flex;
            justify-content:space-around;
            align-items:flex-start;
            z-index:999;
            padding-top: 10px;
            border-radius:20px 20px 0 0;
        }
        .nav-link{
            display:flex;
            flex-direction:column;
            align-items:center;
            font-size:11px;
            color:var(--text-muted);
            text-decoration:none;
            transition:.3s;
            padding-top: 10px;
            width: 20%;
        }
        .nav-link i{
            font-size:20px;
            margin-bottom:4px;
        }
        .nav-link.active{
            color:var(--primary-color);
            font-weight:600;
        }
        
        /* Central Zoom Button Styling */
        .zoom-btn-container {
            width: 80px;
            display: flex;
            justify-content: center;
        }
        .zoom-btn{
            position:relative;
            top:-38px;
            width:65px;
            height:65px;
            background:var(--primary-color);
            border-radius:50%;
            display:flex;
            align-items:center;
            justify-content:center;
            box-shadow: 0 10px 20px rgba(0, 123, 255, 0.5);
            border:5px solid var(--background); /* Use body background for gap effect */
            transition: all 0.3s ease;
        }
        .zoom-btn i{
            color:var(--text-light);
            font-size:28px;
        }
        .zoom-btn:hover {
            transform: scale(1.05);
        }
        .zoom-btn:active {
            transform: scale(0.95);
        }
    </style>
</head>
<body>

    <div class="header">

        <span>Help Center</span>
    </div>

    <div class="help_card_container">
        <a href="https://t.me/srt_web_developer" class="help_card">
            <div class="logo">
                <i class="fa-brands fa-telegram"></i>
            </div>
            <div class="title-area">
                <p class="title">Live Customer Support</p>
                <p class="describe">Contact our official Telegram support for immediate help with any issues.</p>
            </div>
            <i class="fa-solid fa-chevron-right arrow-icon"></i>
        </a>

        <a href="https://t.me/EarningSourceLAB" class="help_card">
            <div class="logo" style="background: var(--secondary-color);">
                <i class="fa-solid fa-users"></i>
            </div>
            <div class="title-area">
                <p class="title">Official Community Group</p>
                <p class="describe">Join our Telegram group to connect and receive the latest news and updates.</p>
            </div>
            <i class="fa-solid fa-chevron-right arrow-icon"></i>
        </a>
        
        <a href="https://t.me/EarningSourceLAB" class="help_card">
            <div class="logo">
                <i class="fa-solid fa-circle-question"></i>
            </div>
            <div class="title-area">
                <p class="title">FAQ & Guide</p>
                <p class="describe">Find quick answers and detailed guides in our Frequently Asked Questions section.</p>
            </div>
            <i class="fa-solid fa-chevron-right arrow-icon"></i>
        </a>

         <a href="https://t.me/EarningSourceLAB" class="help_card">
            <div class="logo" style="background: #ffc107;">
                <i class="fa-solid fa-gavel"></i>
            </div>
            <div class="title-area">
                <p class="title">Terms and Conditions</p>
                <p class="describe">Read our service terms and policies before using the platform.</p>
            </div>
            <i class="fa-solid fa-chevron-right arrow-icon"></i>
        </a>
    </div>

 <!-- Bottom Navigation -->
<nav class="bottom-nav">
  <a href="/dashboard" class="nav-item " aria-label="Home">
    <svg viewBox="0 0 24 24"><path d="M3 12 L12 3 L21 12 V21 H14 V15 H10 V21 H3 Z"/></svg>
    Home
  </a>
  <a href="/my/vip" class="nav-item" aria-label="Income">
    <svg viewBox="0 0 24 24"><rect x="3" y="7" width="18" height="10" rx="2" ry="2" /><polyline points="9 10 15 10 15 14" /></svg>
    Income
  </a>
  <a href="/my-team" class="nav-item" aria-label="Team">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M6 21v-2a4 4 0 0 1 8 0v2"/></svg>
    Team
  </a>
  <a href="/invite" class="nav-item" aria-label="Share">
    <svg viewBox="0 0 24 24"><circle cx="18" cy="5" r="3" /><circle cx="6" cy="12" r="3" /><circle cx="18" cy="19" r="3" /><line x1="8.59" y1="13.51" x2="15.42" y2="17.49"/></svg>
    Share
  </a>
  <a href="/mine" class="nav-item active" aria-label="My Profile">
    <svg viewBox="0 0 24 24"><circle cx="12" cy="7" r="4" /><path d="M5 21v-2a7 7 0 0 1 14 0v2"/></svg>
    My
  </a>
</nav>

<style>
/* Bottom Nav Fixed */
.bottom-nav {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  background: #fff;
  border-top: 1px solid #ddd;
  display: flex;
  justify-content: space-around;
  align-items: center;
  padding: 6px 0;
  box-shadow: 0 -2px 10px rgb(0 0 0 / 10%);
  z-index: 9999; /* সব উপরে থাকবে */
}

.bottom-nav .nav-item {
  text-decoration: none;
  color: #c7b2b4;
  font-size: 12px;
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 2px;
  flex: 1;
  padding: 6px 0;
  transition: 0.3s;
}

.bottom-nav .nav-item svg {
  width: 24px;
  height: 24px;
  stroke: currentColor;
  fill: none;
  stroke-width: 2;
}

.bottom-nav .nav-item.active {
  color: #214ebe;
}

.bottom-nav .nav-item:hover {
  color: #214ebe;
}
</style><?php /**PATH /home/nexivo2437/public_html/resources/views/app/main/service.blade.php ENDPATH**/ ?>